import subprocess
import sys
import logging
import os
from polygonUtils import readPolygons
from os import path
from owslib.wfs import WebFeatureService

def main():
    inputFile = sys.argv[1]
    outputFile = sys.argv[2]
    gdalBin = sys.argv[3]

    polygons = readPolygons(inputFile)
    x = [-y for sub in polygons for (x, y) in sub]
    y = [-x for sub in polygons for (x, y) in sub]
    wfs = WebFeatureService(url='https://rain1.fsv.cvut.cz:4433/services/wfs', version='1.1.0')
    response = wfs.getfeature(typename='bpej', bbox=(min(x), min(y), max(x), max(y)),
                              srsname='urn:ogc:def:crs:EPSG::5514')

    os.remove(outputFile)
    gml = path.splitext(outputFile)[0] + '.gml'
    out = open(gml, 'wb')
    out.write(bytes(response.read(), 'UTF-8'))
    out.close()

    subprocess.run(args = [path.join(gdalBin, 'ogr2ogr.exe'), '-f', 'ESRI Shapefile', outputFile, gml])


log = logging.getLogger('owslib')
log.addHandler(logging.StreamHandler())
log.setLevel(logging.DEBUG)

if __name__ == "__main__":
    main()